<?php
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/../config/db.php';
include __DIR__ . '/../includes/header.php';

$wishlist = $_SESSION['wishlist'] ?? [];
$items = [];
if (!empty($wishlist)) {
  $ids = implode(',', array_map('intval', array_keys($wishlist)));
  $res = db()->query("SELECT id, title, price, image_main FROM products WHERE id IN ($ids)");
  while ($row = $res->fetch_assoc()) $items[] = $row;
}
?>
<div class="container glass-card" style="padding: 16px;">
  <div class="section-title">
    <h2>My Wishlist</h2>
    <p>Saved watches</p>
  </div>
  <?php if (!$items): ?>
    <div class="alert">Your wishlist is empty.</div>
  <?php else: ?>
    <div class="card-grid">
    <?php foreach ($items as $it): ?>
      <div class="product-card glass-card">
        <img src="<?php echo htmlspecialchars($it['image_main']); ?>" alt="">
        <div class="meta">
          <div class="title"><?php echo htmlspecialchars($it['title']); ?></div>
          <div class="price">BDT <?php echo number_format($it['price'], 2); ?></div>
          <div class="actions">
            <a class="btn" href="/WATCHING/pages/product.php?id=<?php echo $it['id']; ?>">View</a>
            <a class="btn" href="/WATCHING/actions/add_to_cart.php?id=<?php echo $it['id']; ?>">Add to Cart</a>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>