<?php include __DIR__ . '/../includes/header.php'; ?>

<div class="container">
    <div class="glass-card" style="padding: 24px; max-width: 800px; margin: 0 auto;">
        <div class="section-title">
            <h2>Product Warranty</h2>
            <p>Comprehensive warranty information for all our watch brands</p>
        </div>
        
        <div class="warranty-content">
            <section class="warranty-section">
                <p>watchesworldbd.com will service every brand name watch sold on our website for a period of 1 to 2 years after purchase (see chart for exceptions). Watches that have symptoms of abnormally gaining time, losing time, or not keeping proper time will be serviced under our warranty program. Our warranty does not cover "external damage" to the product.</p>
            </section>

            <section class="warranty-section">
                <h3>What's Not Covered</h3>
                <p>This limited warranty does not cover any damage if there is evidence of excessive wear and tear, or if used under conditions which exceed the watch manufacturer's water resistance guidelines. Consequential and incidental damages are not recoverable under this warranty or any implied warranties. It also includes:</p>
                
                <ul class="warranty-list">
                    <li><strong>a.</strong> Any defects in material and workmanship of battery, case, crystal, strap or bracelet; including plating on the case and/or bracelet.</li>
                    <li><strong>b.</strong> Damage resulting from improper handling, lack of care, normal wear or tear or aging.</li>
                    <li><strong>c.</strong> Water damage if care instruction of the product's water resistance level (as marked on the product) were not followed.</li>
                    <li><strong>d.</strong> Products that are not purchased from an Authorized Retailer</li>
                </ul>
            </section>

            <section class="warranty-section">
                <h3>Warranty Length of New Watches by Brand</h3>
                <div class="warranty-table-container">
                    <table class="warranty-table">
                        <thead>
                            <tr>
                                <th>Model</th>
                                <th>Warranty Period</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Fossil</td>
                                <td>2 Years</td>
                            </tr>
                            <tr>
                                <td>Diesel</td>
                                <td>2 Years</td>
                            </tr>
                            <tr>
                                <td>Emporio Armani</td>
                                <td>2 Years</td>
                            </tr>
                            <tr>
                                <td>Skagen</td>
                                <td>2 Years</td>
                            </tr>
                            <tr>
                                <td>Casio</td>
                                <td>1 Year</td>
                            </tr>
                            <tr>
                                <td>SANTA BARBARA POLO & RACQUET CLUB</td>
                                <td>1 Year</td>
                            </tr>
                            <tr>
                                <td>DKNY</td>
                                <td>1 Year</td>
                            </tr>
                            <tr>
                                <td>Daniel Klein</td>
                                <td>1 Year</td>
                            </tr>
                            <tr>
                                <td>Armitron</td>
                                <td>1 Year</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </section>
        </div>
    </div>
</div>

<style>
.warranty-content {
    line-height: 1.6;
}

.warranty-section {
    margin-bottom: 32px;
}

.warranty-section h3 {
    font-size: 20px;
    font-weight: 700;
    margin-bottom: 12px;
    color: var(--text);
}

.warranty-section p {
    margin-bottom: 12px;
    color: var(--muted);
}

.warranty-list {
    margin: 16px 0;
    padding-left: 20px;
}

.warranty-list li {
    margin-bottom: 8px;
    color: var(--muted);
}

.warranty-table-container {
    overflow-x: auto;
    margin-top: 16px;
}

.warranty-table {
    width: 100%;
    border-collapse: collapse;
    background: var(--glass);
    border-radius: 12px;
    overflow: hidden;
}

.warranty-table th,
.warranty-table td {
    padding: 12px 16px;
    text-align: left;
    border-bottom: 1px solid var(--glass-border);
}

.warranty-table th {
    background: rgba(255, 255, 255, 0.05);
    font-weight: 700;
    color: var(--text);
}

.warranty-table td {
    color: var(--muted);
}

.warranty-table tr:last-child td {
    border-bottom: none;
}
</style>

<?php include __DIR__ . '/../includes/footer.php'; ?>