<?php
require_once __DIR__ . '/../config/db.php';
include __DIR__ . '/../includes/header.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$stmt = db()->prepare("
  SELECT p.*, b.name AS brand_name, c.name AS cat_name
  FROM products p
  LEFT JOIN brands b ON p.brand_id = b.id
  LEFT JOIN categories c ON p.category_id = c.id
  WHERE p.id = ?
");
$stmt->bind_param("i", $id);
$stmt->execute();
$res = $stmt->get_result();
$p = $res->fetch_assoc();
if (!$p) {
  echo '<div class="container"><div class="alert error">Product not found.</div></div>';
  include __DIR__ . '/../includes/footer.php'; exit;
}
?>
<div class="container">
  <div class="glass-card" style="padding: 16px;">
    <div class="section-title"><h2><?php echo htmlspecialchars($p['title']); ?></h2><p><?php echo htmlspecialchars($p['brand_name']); ?> — <?php echo htmlspecialchars($p['cat_name']); ?></p></div>
    <div class="product-detail">
      <div class="image-wrap glass-card">
        <img src="<?php echo htmlspecialchars($p['image_main'] ?: '/WATCHING/assets/images/placeholder.jpg'); ?>" alt="">
      </div>
      <div class="details">
        <div class="glass-card" style="padding: 16px;">
          <div class="price" style="font-size: 24px;">BDT <?php echo number_format($p['price'], 2); ?></div>
          <p><?php echo nl2br(htmlspecialchars($p['description'])); ?></p>
          <p><strong>Availability:</strong> <?php echo ((int)$p['stock'] > 0) ? 'In Stock' : 'Out of Stock'; ?></p>
          <div class="actions">
            <?php if ((int)$p['stock'] > 0): ?>
              <a class="btn" href="/WATCHING/actions/add_to_cart.php?id=<?php echo $p['id']; ?>">Add to Cart</a>
              <a class="btn" href="/WATCHING/pages/checkout.php?buy_now=<?php echo $p['id']; ?>">Buy Now</a>
            <?php else: ?>
              <a class="btn" href="/WATCHING/actions/add_to_wishlist.php?id=<?php echo $p['id']; ?>">Add to Wishlist</a>
            <?php endif; ?>
          </div>
        </div>

        <div class="glass-card" style="padding: 16px; margin-top: 16px;">
          <h3>Additional Information</h3>
          <table class="table">
            <tr><th>Gender</th><td><?php echo htmlspecialchars($p['gender'] ?: ''); ?></td></tr>
            <tr><th>Family</th><td><?php echo htmlspecialchars($p['family'] ?: ''); ?></td></tr>
            <tr><th>Mechanism Type</th><td><?php echo htmlspecialchars($p['mechanism_type'] ?: ''); ?></td></tr>
            <tr><th>Movement</th><td><?php echo htmlspecialchars($p['movement'] ?: ''); ?></td></tr>
            <tr><th>Case Material</th><td><?php echo htmlspecialchars($p['case_material'] ?: ''); ?></td></tr>
            <tr><th>Case Plating / Color</th><td><?php echo htmlspecialchars($p['case_plating_color'] ?: ''); ?></td></tr>
            <tr><th>Case Size</th><td><?php echo htmlspecialchars($p['case_size'] ?: ''); ?></td></tr>
            <tr><th>Band / Strap Material</th><td><?php echo htmlspecialchars($p['band_material'] ?: ''); ?></td></tr>
            <tr><th>Band / Strap Color</th><td><?php echo htmlspecialchars($p['band_color'] ?: ''); ?></td></tr>
            <tr><th>Band / Strap Size</th><td><?php echo htmlspecialchars($p['band_size'] ?: ''); ?></td></tr>
            <tr><th>Dial Color</th><td><?php echo htmlspecialchars($p['dial_color'] ?: ''); ?></td></tr>
            <tr><th>Water Resistance</th><td><?php echo htmlspecialchars($p['water_resistance'] ?: ''); ?></td></tr>
            <tr><th>Warranty</th><td><?php echo htmlspecialchars($p['warranty'] ?: ''); ?></td></tr>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>