<?php include __DIR__ . '/../includes/header.php'; ?>

<div class="container">
  <section class="privacy-hero glass-card hero-card" style="margin: 24px auto; max-width: 900px;">
    <div class="section-title">
      <h2>Privacy Policy</h2>
      <p>How we collect, use, and protect your information</p>
      <div class="accent-bar"></div>
      <small class="updated">Last updated: <?php echo date('F j, Y'); ?></small>
    </div>
  </section>

  <div class="policy-grid">
    <aside class="toc glass-card">
      <h3>On this page</h3>
      <ul>
        <li><a href="#who-we-are">Who we are</a></li>
        <li><a href="#comments">Comments</a></li>
        <li><a href="#media">Media</a></li>
        <li><a href="#cookies">Cookies</a></li>
        <li><a href="#embedded-content">Embedded content</a></li>
        <li><a href="#share-data">Who we share your data with</a></li>
        <li><a href="#data-retention">How long we retain your data</a></li>
        <li><a href="#your-rights">What rights you have</a></li>
        <li><a href="#data-transfers">Where we send your data</a></li>
      </ul>
    </aside>

    <div class="policy-content glass-card">
      <section class="privacy-section" id="who-we-are">
        <h3>Who we are</h3>
        <p>Our website address is:
          <a href="https://watchesworldbd.com" target="_blank" rel="noopener">https://watchesworldbd.com</a>
        </p>
      </section>

      <section class="privacy-section" id="comments">
        <h3>Comments</h3>
        <p>When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor's IP address and browser user agent string to help spam detection.</p>
        <p>An anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here:
          <a href="https://automattic.com/privacy/" target="_blank" rel="noopener">https://automattic.com/privacy/</a>.
          After approval of your comment, your profile picture is visible to the public in the context of your comment.
        </p>
      </section>

      <section class="privacy-section" id="media">
        <h3>Media</h3>
        <p>If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.</p>
      </section>

      <section class="privacy-section" id="cookies">
        <h3>Cookies</h3>
        <p>If you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.</p>
        <p>If you visit our login page, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.</p>
        <p>When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select "Remember Me", your login will persist for two weeks. If you log out of your account, the login cookies will be removed.</p>
        <p>If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.</p>
      </section>

      <section class="privacy-section" id="embedded-content">
        <h3>Embedded content from other websites</h3>
        <p>Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.</p>
        <p>These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracking your interaction with the embedded content if you have an account and are logged in to that website.</p>
      </section>

      <section class="privacy-section" id="share-data">
        <h3>Who we share your data with</h3>
        <p>If you request a password reset, your IP address will be included in the reset email.</p>
      </section>

      <section class="privacy-section" id="data-retention">
        <h3>How long we retain your data</h3>
        <p>If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.</p>
        <p>For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.</p>
      </section>

      <section class="privacy-section" id="your-rights">
        <h3>What rights you have over your data</h3>
        <p>If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.</p>
      </section>

      <section class="privacy-section" id="data-transfers">
        <h3>Where we send your data</h3>
        <p>Visitor comments may be checked through an automated spam detection service.</p>
      </section>

      <div class="back-top">
        <a href="#who-we-are" class="btn">Back to top</a>
      </div>
    </div>
  </div>
</div>

<style>
/* Page layout */
.policy-grid {
  display: grid;
  grid-template-columns: 280px 1fr;
  gap: 24px;
  align-items: start;
  max-width: 1100px;
  margin: 0 auto 32px;
}
@media (max-width: 900px) { .policy-grid { grid-template-columns: 1fr; } }

/* Premium hero */
.privacy-hero {
  position: relative;
  overflow: hidden;
}
.privacy-hero .section-title h2 {
  font-size: 32px;
  letter-spacing: 0.5px;
}
.privacy-hero .updated {
  color: var(--muted);
}

/* TOC styling */
.toc {
  padding: 16px;
  position: sticky;
  top: 24px;
}
.toc h3 {
  font-size: 16px;
  font-weight: 800;
  margin-bottom: 12px;
}
.toc ul { list-style: none; padding: 0; margin: 0; display: grid; gap: 8px; }
.toc a {
  color: var(--text);
  text-decoration: none;
  opacity: 0.85;
  padding: 8px 10px;
  border-radius: 10px;
  display: block;
  transition: opacity 0.2s ease, background 0.2s ease, transform 0.2s ease;
}
.toc a:hover {
  opacity: 1;
  background: rgba(255,255,255,0.08);
  transform: translateX(4px);
}

/* Content styling */
.policy-content { padding: 24px; }
.privacy-section { margin-bottom: 28px; }
.privacy-section h3 {
  font-size: 20px;
  font-weight: 800;
  margin-bottom: 10px;
}
.privacy-section p { color: var(--muted); margin-bottom: 12px; }
.privacy-section a { color: var(--accent); text-decoration: none; }
.privacy-section a:hover { text-decoration: underline; }

.back-top { margin-top: 8px; }
</style>

<?php include __DIR__ . '/../includes/footer.php'; ?>