<?php
require_once __DIR__ . '/../config/db.php';
include __DIR__ . '/../includes/header.php';

$success = null;
$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $phone = trim($_POST['phone']);
    $email = trim($_POST['email']);
    $message = trim($_POST['message']);
    
    if (empty($name) || empty($phone) || empty($email) || empty($message)) {
        $error = 'All fields are required.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Please enter a valid email address.';
    } else {
        // Create contacts table if it doesn't exist
        $createTable = "CREATE TABLE IF NOT EXISTS contacts (
            id INT AUTO_INCREMENT PRIMARY KEY,
            name VARCHAR(255) NOT NULL,
            phone VARCHAR(20) NOT NULL,
            email VARCHAR(255) NOT NULL,
            message TEXT NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )";
        db()->query($createTable);
        
        $stmt = db()->prepare("INSERT INTO contacts (name, phone, email, message) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("ssss", $name, $phone, $email, $message);
        
        if ($stmt->execute()) {
            $success = 'Thank you for your message! We will get back to you soon.';
        } else {
            $error = 'Sorry, there was an error sending your message. Please try again.';
        }
        $stmt->close();
    }
}
?>

<div class="container">
    <div class="glass-card" style="padding: 24px; max-width: 600px; margin: 0 auto;">
        <div class="section-title">
            <h2>Contact Us</h2>
            <p>Get in touch with us for any questions or support</p>
        </div>
        
        <?php if ($success): ?>
            <div class="alert success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <?php if ($error): ?>
            <div class="alert error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <form method="post" class="contact-form">
            <div class="form-grid">
                <div>
                    <label for="name">Full Name *</label>
                    <input type="text" id="name" name="name" class="input" required 
                           value="<?php echo isset($_POST['name']) ? htmlspecialchars($_POST['name']) : ''; ?>">
                </div>
                
                <div>
                    <label for="phone">Phone Number *</label>
                    <input type="tel" id="phone" name="phone" class="input" required 
                           value="<?php echo isset($_POST['phone']) ? htmlspecialchars($_POST['phone']) : ''; ?>">
                </div>
                
                <div class="full">
                    <label for="email">Email Address *</label>
                    <input type="email" id="email" name="email" class="input" required 
                           value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>">
                </div>
                
                <div class="full">
                    <label for="message">Message *</label>
                    <textarea id="message" name="message" class="textarea" rows="6" required 
                              placeholder="Please describe your inquiry..."><?php echo isset($_POST['message']) ? htmlspecialchars($_POST['message']) : ''; ?></textarea>
                </div>
            </div>
            
            <button type="submit" class="btn btn-lg" style="margin-top: 16px;">Send Message</button>
        </form>
        
        <div class="contact-info-section" style="margin-top: 32px; padding-top: 24px; border-top: 1px solid var(--glass-border);">
            <h3>Other Ways to Reach Us</h3>
            <div class="contact-details">
                <p><strong>Address:</strong> Union Center, 68/1, Gulshan Avenue, Dhaka, Bangladesh</p>
                <p><strong>Phone:</strong> 01713199299</p>
                <p><strong>Email:</strong> info@watchesworldbd.com</p>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>