<?php
require_once __DIR__ . '/config/db.php';
include __DIR__ . '/includes/header.php';

// Fetch featured products
$featured = db()->query("
  SELECT p.*, b.name AS brand_name
  FROM products p
  LEFT JOIN brands b ON p.brand_id = b.id
  WHERE p.is_featured = 1
  ORDER BY p.created_at DESC
  LIMIT 12
");

// Seasonal: for her / for him
$for_her_q = db()->query("
  SELECT p.*, b.name AS brand_name FROM seasonal_collections s
  JOIN products p ON s.product_id = p.id
  LEFT JOIN brands b ON p.brand_id = b.id
  WHERE s.type = 'for_her' LIMIT 1
");
$for_him_q = db()->query("
  SELECT p.*, b.name AS brand_name FROM seasonal_collections s
  JOIN products p ON s.product_id = p.id
  LEFT JOIN brands b ON p.brand_id = b.id
  WHERE s.type = 'for_him' LIMIT 1
");

$best = db()->query("
  SELECT p.*, b.name AS brand_name
  FROM products p
  LEFT JOIN brands b ON p.brand_id = b.id
  WHERE p.is_best_seller = 1
  ORDER BY p.created_at DESC
  LIMIT 12
");
?>
<!-- Full-bleed intro hero -->
<section class="intro-hero full-bleed">
  <div class="hero-inner">
    <div class="glow-field">
      <span class="orb o1"></span>
      <span class="orb o2"></span>
      <span class="orb o3"></span>
      <span class="orb o4"></span>
      <span class="orb o5"></span>
      <span class="aurora"></span>
    </div>
    <!-- removed 'glass-card' to clear background under text -->
    <div class="intro-content hero-card">
      <h1>Timeless. Authentic. Premium.</h1>
      <div class="accent-bar"></div>
      <p>Explore Bangladesh’s finest watch collections.</p>
      <a href="/WATCHING/pages/shop.php" class="btn btn-lg">Shop Now</a>
    </div>
  </div>
</section>

<div class="container">
  <!-- Make the benefits strip full-bleed as well -->
  <section class="benefits-strip glass-card full-bleed">
    <div class="text-slider">
      <span>OFFICIAL BRAND WARRANTY</span>
      <span>0% EMI FACILITY</span>
      <span>ONLINE SUPPORT</span>
      <span>SECURE PAYMENT</span>
      <span>OFFICIAL BRAND WARRANTY</span>
      <span>0% EMI FACILITY</span>
      <span>ONLINE SUPPORT</span>
      <span>SECURE PAYMENT</span>
    </div>
  </section>

  <!-- Remove the old hero section that contained the text slider -->
  <!-- Continue with Featured / Seasonal / Best Seller sections -->
  <section class="glass-card" style="padding: 16px;">
    <div class="section-title">
      <h2>Featured Products</h2>
      <p>Amazing products added recently in our catalog</p>
    </div>
    <div id="featuredCarousel" class="carousel">
      <div class="carousel-track">
        <?php while ($p = $featured->fetch_assoc()): ?>
          <div class="product-card glass-card">
            <?php if ($p['is_new_arrival']) echo '<span class="badge">New</span>'; ?>
            <img src="<?php echo htmlspecialchars($p['image_main'] ?: '/WATCHING/assets/images/placeholder.jpg'); ?>" alt="">
            <div class="meta">
              <div class="title"><?php echo htmlspecialchars($p['title']); ?></div>
              <div class="brand"><?php echo htmlspecialchars($p['brand_name']); ?></div>
              <div class="price">BDT <?php echo number_format($p['price'], 2); ?></div>
              <div class="actions">
                <a class="btn" href="/WATCHING/pages/product.php?id=<?php echo $p['id']; ?>">View</a>
                <?php if ((int)$p['stock'] > 0): ?>
                  <a class="btn" href="/WATCHING/actions/add_to_cart.php?id=<?php echo $p['id']; ?>">Add to Cart</a>
                <?php else: ?>
                  <a class="btn" href="/WATCHING/actions/add_to_wishlist.php?id=<?php echo $p['id']; ?>">Add to Wishlist</a>
                <?php endif; ?>
              </div>
            </div>
          </div>
        <?php endwhile; ?>
      </div>
      <button class="nav-btn left">&#8592;</button>
      <button class="nav-btn right">&#8594;</button>
    </div>
  </section>

  <!-- Seasonal Collection section -->
  <section class="glass-card seasonal-section">
    <div class="section-title">
      <h2>Seasonal Collection</h2>
      <p>Amazing products added recently in our catalog</p>
    </div>
    <div class="split-panels seasonal-panels">
      <div class="panel glass-card premium-panel">
        <?php $her = $for_her_q->fetch_assoc(); if ($her): ?>
          <?php if (!empty($her['is_new_arrival'])) echo '<span class="badge">New</span>'; ?>
          <a class="panel-image-link" href="/WATCHING/pages/product.php?id=<?php echo $her['id']; ?>">
            <img src="<?php echo htmlspecialchars($her['image_main'] ?: '/WATCHING/assets/images/placeholder.jpg'); ?>" alt="<?php echo htmlspecialchars($her['title']); ?>" loading="lazy">
          </a>
          <div class="copy">
            <h3>For Her</h3>
            <p class="subtitle">Curated elegance</p>
          </div>
        <?php else: ?>
          <div class="copy"><h3>For Her</h3><span class="coming-soon">Coming soon</span></div>
        <?php endif; ?>
      </div>
      <div class="panel glass-card premium-panel">
        <?php $him = $for_him_q->fetch_assoc(); if ($him): ?>
          <?php if (!empty($him['is_new_arrival'])) echo '<span class="badge">New</span>'; ?>
          <a class="panel-image-link" href="/WATCHING/pages/product.php?id=<?php echo $him['id']; ?>">
            <img src="<?php echo htmlspecialchars($him['image_main'] ?: '/WATCHING/assets/images/placeholder.jpg'); ?>" alt="<?php echo htmlspecialchars($him['title']); ?>" loading="lazy">
          </a>
          <div class="copy">
            <h3>For Him</h3>
            <p class="subtitle">Refined performance</p>
          </div>
        <?php else: ?>
          <div class="copy"><h3>For Him</h3><span class="coming-soon">Coming soon</span></div>
        <?php endif; ?>
      </div>
    </div>
  </section>

  <!-- Best Seller Products -->
  <section class="glass-card best-section" style="padding: 16px;">
    <div class="section-title">
      <h2>Best Seller Products</h2>
      <p>Only the best seller products added recently in our catalog</p>
    </div>
    <div id="bestSellerCarousel" class="carousel">
      <div class="carousel-track">
        <?php while ($p = $best->fetch_assoc()): ?>
          <div class="product-card glass-card best-card">
            <?php if ($p['is_new_arrival']) echo '<span class="badge">New</span>'; ?>
            <div class="card-image">
              <img src="<?php echo htmlspecialchars($p['image_main'] ?: '/WATCHING/assets/images/placeholder.jpg'); ?>" alt="">
            </div>
            <div class="meta">
              <div class="title"><?php echo htmlspecialchars($p['title']); ?></div>
              <div class="brand"><?php echo htmlspecialchars($p['brand_name']); ?></div>
              <div class="price">BDT <?php echo number_format($p['price'], 2); ?></div>
              <div class="actions">
                <a class="btn" href="/WATCHING/pages/product.php?id=<?php echo $p['id']; ?>">View</a>
                <a class="btn" href="/WATCHING/actions/add_to_cart.php?id=<?php echo $p['id']; ?>">Add to Cart</a>
              </div>
            </div>
          </div>
        <?php endwhile; ?>
      </div>
      <button class="nav-btn left">&#8592;</button>
      <button class="nav-btn right">&#8594;</button>
    </div>
  </section>
</div>
<?php include __DIR__ . '/includes/footer.php'; ?>