<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once __DIR__ . '/../includes/auth.php';
$u = current_user();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>WATCHING - Premium Watch Store</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="/WATCHING/assets/css/styles.css" rel="stylesheet">
  <script defer src="/WATCHING/assets/js/main.js"></script>
</head>
<body class="glass-bg">
<div class="topbar">
  <div class="container">
    <div class="top-links">
      <?php if ($u): ?>
        <span>Hello, <?php echo htmlspecialchars($u['name'] ?: $u['email']); ?></span>
        <a href="/WATCHING/pages/account.php">My account</a>
        <a href="/WATCHING/pages/wishlist.php">My Wishlist</a>
        <a href="/WATCHING/pages/cart.php">Cart</a>
        <a href="/WATCHING/pages/logout.php">Log Out</a>
      <?php else: ?>
        <a href="/WATCHING/pages/login.php">Log In</a>
        <a href="/WATCHING/pages/register.php">Register</a>
        <a href="/WATCHING/pages/wishlist.php">My Wishlist</a>
        <a href="/WATCHING/pages/cart.php">Cart</a>
      <?php endif; ?>
    </div>
  </div>
</div>
<?php include __DIR__ . '/nav.php'; ?>