<?php
require_once __DIR__ . '/../config/db.php';
if (session_status() === PHP_SESSION_NONE) session_start();
if (!isset($_SESSION['admin_id'])) { header('Location: /WATCHING/admin/login.php'); exit; }

$googleOnly = isset($_GET['google']) && $_GET['google'] === '1';

$sql = "SELECT id, name, email, google_id, avatar_url, created_at FROM users";
if ($googleOnly) {
  $sql .= " WHERE google_id IS NOT NULL AND google_id <> ''";
}
$sql .= " ORDER BY created_at DESC";
$res = db()->query($sql);
?>
<!doctype html>
<html>
<head>
  <link href="/WATCHING/assets/css/styles.css" rel="stylesheet">
</head>
<body class="glass-bg">
<div class="container glass-card" style="padding:16px;margin-top:20px;">
  <h2>Users</h2>
  <div style="margin-bottom:10px;">
    <a class="btn" href="/WATCHING/admin/users_list.php">All Users</a>
    <a class="btn" href="/WATCHING/admin/users_list.php?google=1">Google Users</a>
  </div>
  <table class="table">
    <thead>
      <tr>
        <th>Avatar</th>
        <th>Name</th>
        <th>Email</th>
        <th>Login Method</th>
        <th>Registered</th>
      </tr>
    </thead>
    <tbody>
      <?php while ($u = $res->fetch_assoc()): ?>
        <tr>
          <td>
            <?php if (!empty($u['avatar_url'])): ?>
              <img src="<?php echo htmlspecialchars($u['avatar_url']); ?>" alt="Avatar" style="width:40px;height:40px;border-radius:50%;object-fit:cover;">
            <?php else: ?>
              —
            <?php endif; ?>
          </td>
          <td><?php echo htmlspecialchars($u['name'] ?: ''); ?></td>
          <td><?php echo htmlspecialchars($u['email']); ?></td>
          <td><?php echo !empty($u['google_id']) ? 'Google' : 'Email/Password'; ?></td>
          <td><?php echo htmlspecialchars($u['created_at']); ?></td>
        </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>
</body>
</html>