<?php
require_once __DIR__ . '/../config/db.php';
if (session_status() === PHP_SESSION_NONE) session_start();
if (!isset($_SESSION['admin_id'])) { header('Location: /WATCHING/admin/login.php'); exit; }

$ok = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $type = $_POST['type'] === 'for_her' ? 'for_her' : 'for_him';
  $product_id = (int)$_POST['product_id'];
  // Upsert the seasonal record
  $stmt = db()->prepare("INSERT INTO seasonal_collections (type, product_id) VALUES (?, ?)
    ON DUPLICATE KEY UPDATE product_id = VALUES(product_id)");
  $stmt->bind_param("si", $type, $product_id);
  $stmt->execute();
  $ok = 'Seasonal collection updated.';
}

$products = db()->query("SELECT id, title FROM products ORDER BY title ASC");
?>
<!doctype html>
<html><head><link href="/WATCHING/assets/css/styles.css" rel="stylesheet"></head><body class="glass-bg">
<div class="container glass-card" style="padding:16px;margin-top:20px;">
  <h2>Seasonal Collection</h2>
  <?php if ($ok): ?><div class="alert success"><?php echo $ok; ?></div><?php endif; ?>
  <form method="post">
    <label>Type</label>
    <select class="select" name="type">
      <option value="for_her">For Her</option>
      <option value="for_him">For Him</option>
    </select>
    <label>Product</label>
    <select class="select" name="product_id">
      <?php while ($p = $products->fetch_assoc()): ?>
        <option value="<?php echo $p['id']; ?>"><?php echo htmlspecialchars($p['title']); ?></option>
      <?php endwhile; ?>
    </select>
    <button class="btn" type="submit" style="margin-top:10px;">Save</button>
  </form>
</div>
</body></html>