<?php
require_once __DIR__ . '/../config/db.php';
if (session_status() === PHP_SESSION_NONE) session_start();
if (!isset($_SESSION['admin_id'])) { header('Location: /WATCHING/admin/login.php'); exit; }

$ok = null; $error = null;

// Handle form submit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $sku = $_POST['sku'];
  $title = $_POST['title'];
  $price = (float)$_POST['price'];
  $description = $_POST['description'];
  $brand_id = (int)$_POST['brand_id'];
  $category_id = (int)$_POST['category_id'];
  $is_featured = isset($_POST['is_featured']) ? 1 : 0;
  $is_best_seller = isset($_POST['is_best_seller']) ? 1 : 0;
  $is_new_arrival = isset($_POST['is_new_arrival']) ? 1 : 0;

  // Additional info
  $gender = $_POST['gender'] ?: null;
  $family = $_POST['family'] ?: null;
  $mechanism_type = $_POST['mechanism_type'] ?: null;
  $movement = $_POST['movement'] ?: null;
  $case_material = $_POST['case_material'] ?: null;
  $case_plating_color = $_POST['case_plating_color'] ?: null;
  $case_size = $_POST['case_size'] ?: null;
  $band_material = $_POST['band_material'] ?: null;
  $band_color = $_POST['band_color'] ?: null;
  $band_size = $_POST['band_size'] ?: null;
  $dial_color = $_POST['dial_color'] ?: null;
  $water_resistance = $_POST['water_resistance'] ?: null;
  $warranty = $_POST['warranty'] ?: null;

  $stock = isset($_POST['stock']) ? (int)$_POST['stock'] : 0;

  $image_main = null;
  if (!empty($_FILES['image_main']['name'])) {
    $dir = __DIR__ . '/../assets/images/uploads/';
    if (!is_dir($dir)) mkdir($dir, 0777, true);
    $fname = 'prod_' . time() . '_' . preg_replace('/[^a-zA-Z0-9._-]/', '_', $_FILES['image_main']['name']);
    $path = $dir . $fname;
    if (move_uploaded_file($_FILES['image_main']['tmp_name'], $path)) {
      $image_main = '/WATCHING/assets/images/uploads/' . $fname;
    }
  }

  $stmt = db()->prepare("
    INSERT INTO products SET
      sku = ?,
      title = ?,
      description = ?,
      price = ?,
      brand_id = ?,
      category_id = ?,
      image_main = ?,
      stock = ?,
      gender = ?,
      family = ?,
      mechanism_type = ?,
      movement = ?,
      case_material = ?,
      case_plating_color = ?,
      case_size = ?,
      band_material = ?,
      band_color = ?,
      band_size = ?,
      dial_color = ?,
      water_resistance = ?,
      warranty = ?,
      is_featured = ?,
      is_best_seller = ?,
      is_new_arrival = ?
  ");

  $stmt->bind_param(
    "sssdiisisssssssssssssiii",
    $sku, $title, $description, $price, $brand_id, $category_id, $image_main, $stock,
    $gender, $family, $mechanism_type, $movement, $case_material, $case_plating_color, $case_size,
    $band_material, $band_color, $band_size, $dial_color, $water_resistance, $warranty,
    $is_featured, $is_best_seller, $is_new_arrival
  );

  if ($stmt->execute()) { $ok = 'Product added successfully.'; }
  else { $error = 'Failed to add product: ' . $stmt->error; }
  $stmt->close();
}

// Fetch dropdowns
$brands = db()->query("SELECT id, name FROM brands ORDER BY name");
$cats = db()->query("SELECT id, name FROM categories ORDER BY name");
?>
<!doctype html>
<html><head><link href="/WATCHING/assets/css/styles.css" rel="stylesheet"></head><body class="glass-bg">
<div class="container glass-card" style="padding:16px;margin-top:20px;">
  <h2>Add Product</h2>
  <?php if ($ok): ?><div class="alert success"><?php echo $ok; ?></div><?php endif; ?>
  <?php if ($error): ?><div class="alert error"><?php echo $error; ?></div><?php endif; ?>
  <form method="post" enctype="multipart/form-data">
    <div class="form-grid">
      <div><label>Image</label><input class="input" type="file" name="image_main" accept="image/*" required></div>
      <div><label>Title</label><input class="input" name="title" required></div>
      <div><label>Price</label><input class="input" type="number" step="0.01" name="price" required></div>
      <div><label>Stock</label><input class="input" type="number" name="stock" min="0" value="0" required></div>
      <div><label>SKU</label><input class="input" name="sku" required></div>
      <div><label>Brand</label>
        <select class="select" name="brand_id" required>
          <?php while ($b = $brands->fetch_assoc()): ?>
            <option value="<?php echo $b['id']; ?>"><?php echo htmlspecialchars($b['name']); ?></option>
          <?php endwhile; ?>
        </select>
      </div>
      <div><label>Category</label>
        <select class="select" name="category_id" required>
          <?php while ($c = $cats->fetch_assoc()): ?>
            <option value="<?php echo $c['id']; ?>"><?php echo htmlspecialchars($c['name']); ?></option>
          <?php endwhile; ?>
        </select>
      </div>
      <div class="full"><label>Description</label><textarea class="textarea" name="description"></textarea></div>
      <div class="full"><h3>Additional information (Optional)</h3></div>
      <div><label>Gender</label>
        <select class="select" name="gender">
          <option value="">--</option><option>Men</option><option>Women</option><option>Unisex</option>
        </select>
      </div>
      <div><label>Family</label><input class="input" name="family"></div>
      <div><label>Mechanism Type</label><input class="input" name="mechanism_type"></div>
      <div><label>Movement</label><input class="input" name="movement"></div>
      <div><label>Case Material</label><input class="input" name="case_material"></div>
      <div><label>Case Plating / Color</label><input class="input" name="case_plating_color"></div>
      <div><label>Case Size</label><input class="input" name="case_size"></div>
      <div><label>Band / Strap Material</label><input class="input" name="band_material"></div>
      <div><label>Band / Strap Color</label><input class="input" name="band_color"></div>
      <div><label>Band / Strap Size</label><input class="input" name="band_size"></div>
      <div><label>Dial Color</label><input class="input" name="dial_color"></div>
      <div><label>Water Resistance</label><input class="input" name="water_resistance"></div>
      <div><label>Warranty</label><input class="input" name="warranty"></div>

      <div class="full"><h3>Flags</h3></div>
      <div><label><input type="checkbox" name="is_featured"> Featured</label></div>
      <div><label><input type="checkbox" name="is_best_seller"> Best Seller</label></div>
      <div><label><input type="checkbox" name="is_new_arrival"> New Arrival</label></div>
    </div>
    <button class="btn" type="submit" style="margin-top:12px;">Add Product</button>
  </form>
</div>
</body></html>