<?php
require_once __DIR__ . '/../config/db.php';
if (session_status() === PHP_SESSION_NONE) session_start();
if (!isset($_SESSION['admin_id'])) { header('Location: /WATCHING/admin/login.php'); exit; }

$orders = db()->query("SELECT * FROM orders ORDER BY created_at DESC");
?>
<!doctype html>
<html><head><link href="/WATCHING/assets/css/styles.css" rel="stylesheet"></head><body class="glass-bg">
<div class="container glass-card" style="padding:16px;margin-top:20px;">
  <h2>Orders</h2>
  <table class="table">
    <thead>
      <tr>
        <th>Order #</th><th>Status</th><th>Method</th><th>Total</th><th>Customer</th><th>Placed</th>
      </tr>
    </thead>
    <tbody>
      <?php while ($o = $orders->fetch_assoc()): ?>
        <tr>
          <td><?php echo htmlspecialchars($o['order_number']); ?></td>
          <td><?php echo htmlspecialchars($o['status']); ?></td>
          <td><?php echo htmlspecialchars($o['payment_method']); ?></td>
          <td>BDT <?php echo number_format($o['total'],2); ?></td>
          <td><?php echo htmlspecialchars($o['billing_first_name'] . ' ' . $o['billing_last_name']); ?></td>
          <td><?php echo htmlspecialchars($o['created_at']); ?></td>
        </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>
</body></html>