<?php
require_once __DIR__ . '/../config/db.php';
if (session_status() === PHP_SESSION_NONE) session_start();

$error = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email = $_POST['email'];
  $pass = $_POST['password'];
  $stmt = db()->prepare("SELECT id, password_hash FROM admin_users WHERE email = ?");
  $stmt->bind_param("s", $email);
  $stmt->execute();
  $res = $stmt->get_result();
  $user = $res->fetch_assoc();
  if ($user && password_verify($pass, $user['password_hash'])) {
    $_SESSION['admin_id'] = $user['id'];
    header('Location: /WATCHING/admin/dashboard.php'); exit;
  } else {
    $error = 'Invalid credentials';
  }
}
?>
<!doctype html>
<html><head><link href="/WATCHING/assets/css/styles.css" rel="stylesheet"></head><body class="glass-bg">
<div class="container glass-card" style="padding:16px;margin-top:40px;max-width:420px;">
  <h2>Admin Login</h2>
  <?php if ($error): ?><div class="alert error"><?php echo $error; ?></div><?php endif; ?>
  <form method="post">
    <label>Email</label><input class="input" name="email" required>
    <label>Password</label><input class="input" type="password" name="password" required>
    <button class="btn" type="submit" style="margin-top:10px;">Login</button>
  </form>
</div>
</body></html>